#ifndef _FACEBOOK_SONY_H
#define _FACEBOOK_SONY_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	struct PostFacebook
	{
		UInt64 appID;
		const char* userText;
		const char* photoURL;
		const char* photoTitle;
		const char* photoCaption;
		const char* photoDescription;
		const char* actionLinkName;
		const char* actionLinkURL;
	};

	PRX_EXPORT bool PrxFacebookIsBusy();
	PRX_EXPORT bool PrxFacebookGetLastError(ResultCode* result);
	PRX_EXPORT ErrorCode PrxFacebookPostMessage(PostFacebook* message);

	class NpFacebook
	{
		SimpleLock m_Lock;
		bool m_Busy;
		ResultCode m_LastResult;

	public:
		NpFacebook();

		bool ProcessEvent(const sce::Toolkit::NP::Event& event);

		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }

		ErrorCode SetAppID(UInt64 appID);
		ErrorCode PostMessage(PostFacebook* message);
	};

	extern NpFacebook gFacebook;
}

#endif
